/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.integrator;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.integrator.VWManagerNode;
import filenet.vw.apps.taskman.integrator.VWManagerUtil;
import filenet.vw.apps.taskman.integrator.VWPLCredentials;
import filenet.vw.apps.taskman.integrator.resources.VWResource;
import filenet.vw.base.JVMSystemConstants;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VWAdaptorsCredentialPanel
extends VWTaskTabPanel
implements ActionListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private static final long serialVersionUID = 1L;
    private VWManagerNode m_node = null;
    private JList m_list = null;
    private DefaultListModel m_listModel = null;
    private VWToolbarBorder m_listBorder = null;
    private List<String> m_listAdaptors = null;
    private String oldQueueNames = null;
    private String ceuri = null;
    private String connectionPoint = null;
    private String username = null;
    private String pw = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getAdaptors(String ceuri, String cp, String username, String pw, boolean force) {
        String queues = this.m_node.getQueues();
        if (queues != null && !queues.equals("*")) {
            queues = queues.replace("WSRequest", "WSRequest(0)");
            return Arrays.asList(queues.split(","));
        }
        if (!force && this.m_listAdaptors != null) {
            return this.m_listAdaptors;
        }
        VWSession ses = null;
        ArrayList<String> adaptorNames = new ArrayList<String>(5);
        adaptorNames.add("WSRequest(0)");
        try {
            JVMSystemConstants.SetPrivilegedSystemProperty("filenet.vw.api.rpc.timeout", "200");
            ses = new VWSession();
            ses.setBootstrapCEURI(ceuri);
            ses.logon(username, pw, cp);
            String[] qnames = ses.fetchQueueNames(1);
            int nQueues = qnames == null ? 0 : qnames.length;
            for (int i = 0; i < qnames.length; ++i) {
                String component_descriptor;
                VWQueue queue = null;
                VWQueueDefinition qdef = null;
                VWAttributeInfo attributes = null;
                queue = ses.getQueue(qnames[i]);
                if (queue != null) {
                    qdef = queue.fetchQueueDefinition();
                }
                if (qdef != null) {
                    attributes = qdef.getAttributeInfo();
                }
                if (attributes == null || (component_descriptor = (String)attributes.getFieldValue("F_ComponentDescriptor")) == null) continue;
                VWXMLWrapper component_descriptor_doc = new VWXMLWrapper(component_descriptor);
                String adaptor_name = VWXMLWrapper.getNodeValue(component_descriptor_doc.getRootNode(), "name");
                if (adaptor_name == null) {
                    adaptor_name = qnames[i];
                }
                adaptorNames.add(adaptor_name);
            }
        }
        catch (Exception e) {
        }
        finally {
            if (ses != null) {
                try {
                    ses.logoff();
                }
                catch (VWException e) {}
            }
            ses = null;
        }
        return adaptorNames;
    }

    public VWAdaptorsCredentialPanel(VWManagerNode node) {
        this.m_node = node;
        VWManagerUtil m_util = new VWManagerUtil(0);
        try {
            VWAuthItem item = m_util.getDString(this.m_node.getOptions());
            this.username = item.getName();
            this.pw = item.getPassword();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.ceuri = this.m_node.getCEURI();
        this.connectionPoint = this.m_node.getConnectionPoint();
        this.initLayout();
        this.updateState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getListFromFile() {
        String fileName = this.m_node.getAdaptorsFileName();
        JList jList = this.m_list;
        DefaultListModel l = this.m_listModel;
        if (l == null) {
            return;
        }
        l.clear();
        if (jList != null) {
            jList.clearSelection();
        }
        FileInputStream inStream = null;
        try {
            Properties p = new Properties();
            inStream = new FileInputStream(fileName);
            p.load(inStream);
            Enumeration<Object> keys = p.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String options = p.getProperty(key);
                VWManagerUtil m_util = new VWManagerUtil(0);
                VWAuthItem item = m_util.getDString(options);
                l.addElement(new ADAPTORSITEM(key, item.getName(), item.getPassword()));
            }
            if (jList != null) {
                jList.updateUI();
                if (l.size() > 0) {
                    jList.setSelectedIndex(0);
                }
            }
        }
        catch (Throwable t) {
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeListToFile(String fileName, DefaultListModel l) {
        if (l == null) {
            return;
        }
        FileOutputStream outStream = null;
        try {
            Properties p = new Properties();
            int n = l.size();
            for (int i = 0; i < n; ++i) {
                ADAPTORSITEM item = (ADAPTORSITEM)l.get(i);
                VWManagerUtil m_util = new VWManagerUtil(0);
                String key = item.itemName;
                p.setProperty(key, m_util.getEString(item.user, item.pw));
            }
            outStream = new FileOutputStream(fileName);
            p.store(outStream, "");
        }
        catch (Throwable t) {
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void initLayout() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.m_listBorder = new VWToolbarBorder(VWResource.Adaptors, 272629808);
        this.m_listBorder.addToolbarBorderActionNotifier(this);
        JPanel clientPanel = this.m_listBorder.getClientPanel();
        clientPanel.setLayout(new BorderLayout());
        JPanel listPanel = new JPanel(new BorderLayout());
        this.m_listModel = new DefaultListModel();
        this.getListFromFile();
        this.m_list = new JList(this.m_listModel);
        this.m_list.setSelectionMode(0);
        this.m_list.addListSelectionListener(this);
        listPanel.add((Component)this.m_list, "Center");
        clientPanel.add((Component)new JScrollPane(listPanel, 20, 30), "Center");
        c.fill = 1;
        c.anchor = 23;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 5);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.m_listBorder, c);
    }

    public void updateState() {
        if (!this.m_node.isStarted()) {
            int index = this.m_list.getSelectedIndex();
            boolean itemSelected = index != -1;
            this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 1, 16));
            this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 1, 0x400000));
            if (itemSelected) {
                this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 1, 0x10000000));
                this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 1, 32));
            }
            this.m_list.setEnabled(true);
        } else {
            this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            this.m_list.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        this.updateState();
    }

    @Override
    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            int id = event.getID();
            switch (id) {
                case 0x400000: {
                    this.m_listAdaptors = this.getAdaptors(this.ceuri, this.connectionPoint, this.username, this.pw, true);
                    break;
                }
                case 16: {
                    this.m_listAdaptors = this.getAdaptors(this.ceuri, this.connectionPoint, this.username, this.pw, false);
                    VWPLCredentials credDlg = VWPLCredentials.getInstance(this.m_listAdaptors, VWResource.Adaptor);
                    credDlg.show();
                    if (!credDlg.getIsCanceled()) {
                        String selPLRef = credDlg.getItem();
                        int selIndex = -1;
                        for (int i = 0; i < this.m_listModel.size(); ++i) {
                            ADAPTORSITEM item = (ADAPTORSITEM)this.m_listModel.get(i);
                            if (!item.itemName.equals(selPLRef)) continue;
                            selIndex = i;
                            break;
                        }
                        if (selIndex == -1) {
                            this.m_listModel.addElement(new ADAPTORSITEM(credDlg.getItem(), credDlg.getUsername(), credDlg.getPassword()));
                        } else {
                            ADAPTORSITEM item = (ADAPTORSITEM)this.m_listModel.get(selIndex);
                            item.user = credDlg.getUsername();
                            item.pw = credDlg.getPassword();
                            this.m_list.updateUI();
                        }
                    }
                    this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, null));
                    break;
                }
                case 0x10000000: {
                    int index = this.m_list.getSelectedIndex();
                    this.m_listModel.remove(index);
                    if (index < this.m_listModel.size()) {
                        this.m_list.setSelectedIndex(index);
                    } else if (this.m_listModel.size() > 0) {
                        this.m_list.setSelectedIndex(index - 1);
                    }
                    this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, null));
                    break;
                }
                case 32: {
                    ADAPTORSITEM item = (ADAPTORSITEM)this.m_list.getSelectedValue();
                    VWPLCredentials dlg = VWPLCredentials.getInstance(item.itemName, item.user, item.pw, VWResource.Adaptor);
                    dlg.show();
                    if (!dlg.getIsCanceled()) {
                        item.user = dlg.getUsername();
                        item.pw = dlg.getPassword();
                        this.m_list.updateUI();
                    }
                    this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, null));
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.m_node.displayError(ex);
        }
    }

    protected void applyProperties() {
        VWAdaptorsCredentialPanel.writeListToFile(this.m_node.getAdaptorsFileName(), this.m_listModel);
    }

    @Override
    public String getHelpPage() {
        return VWHelp.Help_Process_TaskManager + "cm_config_libraries.htm";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    protected static class ADAPTORSITEM {
        String itemName;
        String user;
        String pw;

        protected ADAPTORSITEM(String a, String b, String c) {
            this.itemName = a;
            this.user = b;
            this.pw = c;
        }

        public String toString() {
            return this.itemName + " [" + this.user + "]";
        }
    }
}

